const express = require('express');
const http = require('http');
const bodyParser = require('body-parser');
const cors = require('cors');
const setupSocket = require('./sockets/socket.js');

const app = express();
const server = http.createServer(app);

const PORT = process.env.PORT || 4000;

app.use(express.json({ limit: '500mb' }));
app.use(express.urlencoded({ limit: '500mb' }));
app.use(bodyParser.json());
app.use(cors());

app.use(function (req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'Access-Control-Allow-Headers, Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers, X-Access-Token, XKey, Authorization');
    next();
});

const router = require('./routes/router.js');
app.use('/api', router);

server.listen(PORT, () => console.log(`Server running on port ${PORT}`));

// Setup Socket.IO
setupSocket(server);
