const jwt = require('jsonwebtoken');
const db = require("../lib/db.js");


module.exports = {
  isLoggedIn: (req, res, next) => {
    try {
      const token = req.headers.authorization.split(' ')[1];

      const decoded = jwt.verify(
        token,
        process.env.JWT_KEY
      );
      req.userData = decoded;

      console.log(decoded)
      if(req.userData){


        db.query(
          `select * from customers where id=?`,
          [req.userData.userId],
          (err, result) => {
            if (err) {
              console.log(err);
            } else {
      
              if(result.length>0){
                next();

              }
              else{
                return res.status(401).send({
                  msg: 'Your session is not valid!'
                });
              }
      
           
            }
          }
        );

      }
     } catch (err) {
        console.log(err)
      return res.status(401).send({
        msg: 'Your session is not valid!'
      });
    }
  },
  isLoggedInOrNot: (req, res, next) => {
    try {
      const token = req.headers.authorization.split(' ')[1];

      const decoded = jwt.verify(
        token,
        process.env.JWT_KEY
      );
      req.userData = decoded;

      console.log(decoded)
      if(req.userData){
        next();
      }
      else{
        req.userData={}
        req.userData.userId=null 
               next();

      }
     } catch (err) {
      req.userData={}
      req.userData.userId=null
      next();
    }
  },
    
    isSuperAdmin: (req, res, next) => {
      try {

        const token = req.headers.authorization.split(' ')[1];

        const decoded = jwt.verify(
          token,
          process.env.JWT_KEY
        );
        req.userData = decoded;
        console.log(req.userData)
        if(req.userData.role=="admin")
        next();
        else
        return res.status(401).send({
          msg: 'ليس لديك صلاحية لهذا الاجراء'
        });
      } catch (err) {
          console.log(err)
        return res.status(401).send({
          msg: 'Your session is not valid!'
        });
      }
    },
 
  };