const socketIo = require('socket.io');
const jwt = require('jsonwebtoken');
const db = require("../lib/db.js");
const { default: Expo } = require('expo-server-sdk');

function setupSocket(server) {
    const io = socketIo(server);
    
    io.use((socket, next) => {
        try {
            console.log('Authintication Started');

            const token = socket.handshake.query.token;

            if (!token) {
                throw new Error('Token is missing');
            }

            jwt.verify(token, process.env.JWT_KEY, (err, decoded) => {
                if (err) {
                    throw new Error('Invalid token');
                }

                socket.userData = decoded;
                

                if(decoded.role === 'admin'){
                    db.query('SELECT * FROM admins WHERE id = ?', [socket.userData.userId], (err, result) => {
                        if (err) {
                            console.error(err);
                            throw new Error('Database query error');
                        }
    
                        if (result.length > 0) {
                            db.query(
                                `update admins set socketid=? where id=?`,[socket.id,socket.userData.userId] ,
                                (err, result) => {
                                  if (err) {
                                    console.log(err)
                                  } else {
                                        next();
    
                                  }
                                }
                              );
                        } else {
                            throw new Error('Invalid user');
                        }
                    });

                }
                else{
                    db.query('SELECT * FROM users WHERE id = ?', [socket.userData.userId], (err, result) => {
                        if (err) {
                            console.error(err);
                            throw new Error('Database query error');
                        }
    
                        if (result.length > 0) {
                            db.query(
                                `update users set socketid=? where id=?`,[socket.id,socket.userData.userId] ,
                                (err, result) => {
                                  if (err) {
                                    console.log(err)
                                  } else {
                                        next();
    
                                  }
                                }
                              );
                        } else {
                            throw new Error('Invalid user');
                        }
                    });
                }
             
            });
        } catch (err) {
            console.error(err);
            socket.emit('notAuthorized', "Your Session Is Not Valid");
            
        }
    });

    io.on('connection', (socket) => {
        console.log('A user connected');

        socket.on('message', (data) => {
            db.query(
                `insert into chat (user,sender,message,file,filename) values (?,?,?,?,?)`,[socket.userData.userId,1, data.message,data.file,data.fileName] ,
                (err, result) => {
                  if (err) {
                    console.log(err)
                  } else {
                    io.emit('messageack', data);

                  }
                }
              );
              db.query(
                `select socketid from admins`,
                (err, result) => {
                  if (err) {
                    console.log(err)
                  } else {
                    result.forEach(admin => {
                        io.to(admin.socketid).emit('message', data);

                    });

                  }
                }
              );


       
        });
        socket.on('adminmessage', (data) => {

            if(socket.userData.role="admin"){
            data=JSON.parse(data)
            console.log(data)
            db.query(
                `insert into chat (user,sender,message,file,filename) values (?,?,?,?,?)`,[data.user,0, data.message,data.file,data.fileName] ,
                (err, result) => {
                  if (err) {
                    console.log(err)
                  } else {
                    io.emit('messageack', data);
                    data.dateadded=new Date()
                    db.query(
                        `select socketid from users where id=?`,[data.user] ,
                        (err, result) => {
                          if (err) {
                            console.log(err)
                          } else {
                            io.to(result[0]?.socketid).emit('message', data);
                            sendNotification("رسالة جديدة", data.message,[data.user])
                          }
                        }
                      );
                  }
                }
              );
           

            }
        });
        socket.on('disconnect', () => {
            console.log('A user disconnected');
        });
    });

    return io;
}
const sendNotification=(title,body,users)=>{
  

  db.query(
    `select token from notificationtokens where user in (?)`,[users],
    (err, result) => {
      if (err) {
        console.log(err)
    
      } else {
let expo = new Expo({ accessToken: process.env.EXPO_ACCESS_TOKEN });

let messages = [];
for (let pushToken of result) {
console.log(pushToken)
  pushToken=pushToken.token
  if (!Expo.isExpoPushToken(pushToken)) {
    console.error(`Push token ${pushToken} is not a valid Expo push token`);
    continue;
  }

  messages.push({
    to: pushToken,
    sound: 'default',
    title,
    body
  })
}
users.forEach(user => {
  try{
    db.query(`insert into notifications (user,title,body) values(?,?,?)`,[user,title,body],
    (err, result) => {
      if (err) {
        console.log(err)
    
      }
    
    }
      )

  } catch{
      
    }

});
let chunks = expo.chunkPushNotifications(messages);
let tickets = [];
(async () => {
  for (let chunk of chunks) {
    try {
      let ticketChunk = await expo.sendPushNotificationsAsync(chunk);
      console.log(ticketChunk);
      tickets.push(...ticketChunk);
    } catch (error) {
      console.error(error);
    }
  }
})();


let receiptIds = [];
for (let ticket of tickets) {
  if (ticket.id) {
    receiptIds.push(ticket.id);
  }
}

let receiptIdChunks = expo.chunkPushNotificationReceiptIds(receiptIds);
(async () => {
  for (let chunk of receiptIdChunks) {
    try {
      let receipts = await expo.getPushNotificationReceiptsAsync(chunk);
      console.log(receipts);
      for (let receiptId in receipts) {
        let { status, message, details } = receipts[receiptId];
        if (status === 'ok') {
          continue;
        } else if (status === 'error') {
          console.error(
            `There was an error sending a notification: ${message}`
          );
          if (details && details.error) {
            console.error(`The error code is ${details.error}`);
          }
        }
      }
    } catch (error) {
      console.error(error);
    }
  }
})();
      }
    }
  );

}
module.exports = setupSocket;
